import * as z from "zod";

export const formSchema = z.object({
    start: z.string().optional(),
    end: z.string().optional(),
    adult: z.number().default(1),
    child: z.number().default(0),
  });

  export const bookingFormSchema = z.object({
    start: z.string(),
    end: z.string(),
    adult: z.number(),
    child: z.number(),
    usd: z.number(),
    idr: z.number(),
    firstname: z.string().min(2, {
      message: "Firstname must be at least 2 characters.",
    }),
    lastname: z.string().min(2, {
      message: "Lastname must be at least 2 characters.",
    }),
    email: z.string().email("Invalid email address"),
    phone: z
      .string()
      .regex(/^\+?\d+$/, {
        message: "Please enter a valid number",
      })
      .min(6, {
        message: "Phone number must be at least 6 digits long",
      }),
    address: z.string().default("No Address"),
    message: z.string().default("No Message"),
  });