import moment from "moment";

export function getDisabledDates(ranges: any[]): Date[] {
    const disabledDates: Date[] = [];
    const today = moment().startOf('day'); 
  
    for (const range of ranges) {
      const blockedStartDate = moment(range.start).startOf('day');
      const blockedEndDate = moment(range.end).startOf('day');
      const overlapping = range.overlappingDate;
  
      if (overlapping) {
        disabledDates.push(new Date(overlapping));
      }
  
      if (blockedStartDate.isSame(today, 'day')) {
        const blockedEnd = blockedEndDate.subtract(1, 'days');

        let currentDate = blockedStartDate.toDate();
        while (currentDate <= blockedEnd.toDate()) {
          disabledDates.push(new Date(currentDate));
          currentDate.setDate(currentDate.getDate() + 1);
        }
      } else {
        const blockedEnd = blockedEndDate.subtract(1, 'days');
        const blockedStart = blockedStartDate.add(1, 'days');
  
        let currentDate = blockedStart.toDate();
        while (currentDate <= blockedEnd.toDate()) {
          disabledDates.push(new Date(currentDate));
          currentDate.setDate(currentDate.getDate() + 1);
        }
      }
    }

    return disabledDates;
  }