// Simple reusable query hook
"use client";
import { useQuery} from "@tanstack/react-query";

interface GetProps {
  key: string;
  fn: () => Promise<any>; // Should return Promise for queries
}

export const useGet = ({key, fn}: GetProps) => {
  return useQuery({
    queryKey: [key],
    queryFn: fn,
    refetchInterval: 60000,
    refetchIntervalInBackground: true,
    refetchOnWindowFocus: false,
  });
};