"use client";
import Link from "next/link";
import {Button} from "../ui/button";

export default function StatusSuccess() {
  return (
    <div className="space-y-5 lg:w-[70%] w-full px-10 text-center lg:text-start">
        <h1 className="text-white">
          Thank you, your reservation has been confirmed.
        </h1>
        <p className="text-sm text-white">
          Please check your <span className="font-bold text-white">Email</span> to see your
          Trip Details.
        </p>
        <Button
          asChild
          type="button"
          className="text-white bg-second hover:bg-second/80"
        >
          <Link href="/" className="font-bold tracking-wide m-0">
            Back to Home
          </Link>
        </Button>
      </div>
  );
}