"use client";
import Link from "next/link";
import {Button} from "../ui/button";

export default function StatusFailed() {
  return (
    <div className="px-5 lg:px-0 w-full lg:w-[70%] text-left space-y-4">
      <h1 className="text-white capitalize">oops! something went wrong!</h1>
      <p className="text-sm text-white">Please contact us below!</p>
      <div className="flex gap-2 items-center justify-start">
        <Button
          asChild
          type="button"
          className="text-white bg-second hover:bg-second/80"
        >
          <Link href="/" className="font-bold tracking-wide m-0">
            Back to Home
          </Link>
        </Button>
        <Button
          asChild
          type="button"
          className="text-white bg-second hover:bg-second/80"
        >
          <Link
            href="https://wa.me/6287861854989"
            target="_blank"
            className="font-bold tracking-wide m-0"
          >
            Contact Us
          </Link>
        </Button>
      </div>
    </div>
  );
}
