"use client";
import Image from "next/image";
import Link from "next/link";
import {RiMenu3Fill} from "react-icons/ri";
import {BsFacebook, BsInstagram, BsWhatsapp} from "react-icons/bs";

import {
  Sheet,
  SheetClose,
  SheetContent,
  SheetTrigger,
} from "@/components/ui/sheet";
import {cn} from "@/lib/utils";

interface Props {
  nav: any
  className?: string;
}

export default function SheetMB({className, nav}: Props) {

  return (
    <Sheet>
      <SheetTrigger className="lg:hidden">
        <RiMenu3Fill size={30} className={cn(className)} />
      </SheetTrigger>
      <SheetContent className="space-y-5 flex flex-col justify-between bg-main border-none">
        <div className="flex items-center justify-center pt-10">
          <Image
            src="/checkout/logo.svg"
            alt="Villa La Mainson"
            width={563}
            height={212}
            className="object-cover w-32"
          />
        </div>
        <ul className="flex flex-col justify-center items-center gap-5 tracking-wide text-lg">
          {nav.map((item: any, index: number) => (
            <li key={index} className="text-[18px] tracking-wide font-semibold text-second">
              <SheetClose asChild key={index}>
                <Link href={item.href}>{item.title}</Link>
              </SheetClose>
            </li>
          ))}
        </ul>
        <div className="flex flex-col justify-center items-center gap-5 ">
          <div className="flex flex-row gap-5 justify-center items-center">
            <a href="https://www.facebook.com/zangoubud/" target="_blank" rel="noreferrer">
              <BsFacebook size={26} className="text-second" />
            </a>
            <a href="https://www.instagram.com/zangoubud/" target="_blank" rel="noreferrer">
              <BsInstagram size={26} className="text-second" />
            </a>
            <a href="https://wa.me/+6287861854989?text=Hi%2C+I+saw+4BR+-+Zango+from+its+website%2C+and+I+would+like+to+enquire+about+this+villa." target="_blank" rel="noreferrer">
              <BsWhatsapp size={26} className="text-second" />
            </a>
          </div>
          <div className="text-second text-center tracking-wider">
            <a
              href="https://balimanagement.villas"
              target="_blank"
              className="text-sm"
              rel="noreferrer"
            >
              Managed by
              <br /> Bali Management Villas
            </a>
          </div>
        </div>
      </SheetContent>
    </Sheet>
  );
}
