"use client";

import {Minus, Plus} from "lucide-react";
import {useCallback, useEffect, useState} from "react";
import {cn} from "@/lib/utils";

interface Props {
  title: string;
  subtitle: string;
  value: number;
  onChange: (value: number, name: string) => void;
  className?: string;
  className2?: string;
  className3?: string;
  className4?: string;
  totalGuestCount: number;
  maxGuestLimit: number;
  disableLimit: number;
  action: string;

}

export default function Counter({
  title,
  subtitle,
  value,
  onChange,
  className,
  className2,
  className3,
  className4,
  totalGuestCount,
  maxGuestLimit,
  disableLimit,
  action
}: Props) {
  const [hiddenInputValue, setHiddenInputValue] = useState(value);

  useEffect(() => {
    setHiddenInputValue(value);
  }, [value]);

  const onAdd = useCallback(() => {
    if (totalGuestCount < maxGuestLimit) {
      onChange(value + 1, action);
    }
  }, [onChange, value, totalGuestCount, maxGuestLimit]);

  const onReduce = useCallback(() => {
    if (value === 0) {
      return;
    }
    onChange(value - 1, action);
  }, [value, onChange]);

  const onDisabled = value <= disableLimit;

  return (
    <div className="grid grid-cols-2 items-center gap-5 md:gap-10 lg:gap-5 md:justify-between">
      <div className={cn("flex flex-col",className4)}>
        <p className={cn("text-base font-bold ", className)}>{title}</p>
        <p className={cn("text-xs", className)}>{subtitle}</p>
      </div>
      <div className={cn("flex flex-row",className3)}>
        <button
          onClick={onReduce}
          disabled={onDisabled}
          type="button"
          className={cn(
            "w-10 h-10 rounded-full flex items-center justify-center cursor-pointer",
            {"cursor-not-allowed opacity-50": onDisabled},
            className2
          )}
        >
          <Minus className={cn("", className2)} />
        </button>
        <p className={cn("font-light text-xl", className)}>{value}</p>
        <button
          onClick={onAdd}
          type="button"
          className={cn(
            "w-10 h-10 rounded-full flex items-center justify-center",
            {
              "cursor-not-allowed opacity-50": totalGuestCount >= maxGuestLimit,
              "cursor-pointer": totalGuestCount < maxGuestLimit,
            },
            className2
          )}
        >
          <Plus className={cn("", className2)} />
        </button>
      </div>
      <input
        type="hidden"
        name={`${title.toLowerCase()}Counter`}
        value={hiddenInputValue}
      />
    </div>
  );
}
