"use client";

import {useState, useEffect} from "react";
import {DateRange, Range, RangeKeyDict} from "react-date-range";
import {id} from "date-fns/locale";

import "react-date-range/dist/styles.css"; // main style file
import "react-date-range/dist/theme/default.css"; // theme css file

interface Availability {
  value: Range;
  onChange: (value: RangeKeyDict) => void;
  disabledDates?: Date[];
}

export default function CalendarWidget({value, disabledDates, onChange: changes}: Availability) {
    const [isMobile, setIsMobile] = useState(false);
    
    useEffect(() => {
      const handleResize = () => {
        setIsMobile(window.innerWidth < 768);
      };
      handleResize();
      window.addEventListener("resize", handleResize);
      return () => {
        window.removeEventListener("resize", handleResize);
      };
    }, []);
    
    return (
      <>
        <DateRange
          className="!w-full mx-auto !bg-transparent !font-nunito"
          classNames={{
            dayDisabled: "!bg-[#EBECE7] !text-[#50514C]",
            dayNumber: "!text-sm",
            startEdge: "!rounded-l-[5px] !text-main",
            endEdge: "!rounded-r-[5px] !text-main",
            dayStartPreview: "!rounded-l-[5px] !border-main",
            dayEndPreview: "!rounded-r-[5px] !border-main",
            dayEndOfWeek: "!rounded-none ",
            dayStartOfWeek: "!rounded-none ",
            inRange: "!rounded-none !text-main !border-main",
            dayInPreview: "!rounded-none !border-main",
            monthName: "!text-center !px-0 !pb-[10px] !text-[#221B19] ",
            nextButton:
              "!bg-white !rounded-[4px] !w-[32px] !h-[32px] !border border-[#D8DAE5] !mx-auto !flex justify-center items-center",
            prevButton:
              "!bg-white !rounded-[4px] !w-[32px] !h-[32px] !border border-[#D8DAE5] !mx-auto !flex justify-center items-center",
            nextPrevButton: "!m-0",
            month: "!w-[24em]"
          }}
          onChange={changes}
          minDate={new Date()}
          ranges={[value]}
          date={new Date()}
          months={2}
          direction={isMobile ? "vertical" : "horizontal"}
          showDateDisplay={false}
          disabledDates={disabledDates}
          scroll={isMobile ? { enabled: true } : { enabled: false }}
          weekdayDisplayFormat="EEEEE"
          preventSnapRefocus={true}
         locale={idWithEnglish}
      />
    </>
  );
}

const idWithEnglish = {
  ...id,
  localize: {
    ...(id.localize || {}),
    month: (n: number) => {
      const months = [
        "January",
        "February",
        "March",
        "April",
        "May",
        "June",
        "July",
        "August",
        "September",
        "October",
        "November",
        "December",
      ];
      return months[n];
    },
    day: (n: number) => {
      const days = ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"];
      return days[n];
    },
    // Provide default implementations for required methods
    ordinalNumber: id.localize?.ordinalNumber || ((n: number) => String(n)),
    era: id.localize?.era || ((n: number) => String(n)),
    quarter: id.localize?.quarter || ((n: number) => String(n)),
    dayPeriod: id.localize?.dayPeriod || ((n: number) => String(n)),
  },
};