"use client";

import {Card, CardContent} from "@/components/ui/card";
import {Popover, PopoverContent, PopoverTrigger} from "@/components/ui/popover";

import {BsFillPersonFill} from "react-icons/bs";
import {IoBed} from "react-icons/io5";
import {FaShower} from "react-icons/fa";
import  {domToReact} from "html-react-parser";
import {RiInformationLine} from "react-icons/ri";
import {AiOutlineLoading3Quarters} from "react-icons/ai";
import {Button} from "../ui/button";
import {useState} from "react";
import Image from "next/image";

interface Props {
  result: any;
  loadingCheck: boolean;
  openForm: () => void;
  cancelForm: () => void;
}
const ResultForm = ({result, loadingCheck, openForm, cancelForm}: Props) => {
  const [openCancel, setOpenCancel] = useState(false);
  const BookNow = () => {
    openForm();
    setOpenCancel(true);
  };

  const cancelBtn = () => {
    setOpenCancel(false);
    cancelForm();
  };
  const options = {
    replace: (node: any) => {
      if (!node.attribs) {
        return;
      }

      if (node.name === "p") {
        return <p>{domToReact(node.children, options)}</p>;
      }
    },
  };

  if (result && result.success) {
    return (
      <Card className="h-full rounded">
        <CardContent className="p-6 h-full relative">
          {loadingCheck && (
            <div className="absolute top-0 left-0 w-full h-full bg-white">
              <div className="flex items-center justify-center h-full w-full">
                <AiOutlineLoading3Quarters className="animate-spin h-16 w-16 text-main" />
              </div>
            </div>
          )}
          <div className="grid grid-cols-1 lg:grid-cols-3 gap-5 h-full w-full">
            <div className="w-full">
              <Image
                src="/checkout/main-img.jpg"
                alt="Villa La Mainson"
                width={320}
                height={320}
                loading="eager"
                className="object-cover rounded h-full w-full"
              />
            </div>
            <div className="lg:col-span-2 flex flex-col justify-between gap-3">
              <h3 className="text-xl underline underline-offset-4 text-second">
                Staying From : {result.data.date}
              </h3>
              <div className="flex items-center gap-2">
                <span className="font-bold leading-loose text-second lg:text-xl text-sm">
                  IDR {result.data.idr.toLocaleString("id-ID")}
                </span>
                <Popover>
                  <PopoverTrigger>
                    <RiInformationLine />
                  </PopoverTrigger>
                  <PopoverContent
                    side="right"
                    align="center"
                    className="w-auto"
                  >
                    <p className="text-base">
                      Price in USD :{" "}
                      <span className="font-bold">
                        USD {result.data.usd.toLocaleString("us-US")}
                      </span>
                    </p>{" "}
                  </PopoverContent>
                </Popover>
              </div>
              <span className="text-main capitalize font-bold text-base">
                price for {result.data.nights}{" "}
                {result.data.nights > 1 ? "nights" : "night"}
              </span>{" "}
              <div className="flex items-center gap-2">
                <span>Price details</span>
                <Popover>
                  <PopoverTrigger>
                    <RiInformationLine />
                  </PopoverTrigger>
                  <PopoverContent
                    side="right"
                    align="center"
                    className="w-auto"
                  >
                    <div className="space-y-2">
                      {result.data.price.map((item: any, index: any) => (
                        <div key={index} className="flex items-center gap-x-3">
                          <span className="text-sm">{item.date}</span>
                          <span className="text-base font-bold">
                            Rp. {item.idr.toLocaleString("id-ID")}
                          </span>
                        </div>
                      ))}
                    </div>
                  </PopoverContent>
                </Popover>
              </div>
              <div className="w-full">
                {openCancel ? (
                  <Button
                    className="w-full bg-main hover:bg-main/80"
                    onClick={cancelBtn}
                  >
                    Cancel
                  </Button>
                ) : (
                  <Button
                    className="w-full bg-main hover:bg-main/80"
                    onClick={BookNow}
                  >
                    Book Now
                  </Button>
                )}
              </div>
            </div>
          </div>
        </CardContent>
      </Card>
    );
  }

  return (
    <Card className="h-full rounded">
      <CardContent className="p-6 h-full relative">
        {loadingCheck && (
          <div className="absolute top-0 left-0 w-full h-full bg-white">
            <div className="flex items-center justify-center h-full w-full">
              <AiOutlineLoading3Quarters className="animate-spin h-16 text-main w-16" />
            </div>
          </div>
        )}
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-5 h-full w-full">
          <div className="w-full">
            <Image
              src="/checkout/main-img.jpg"
              alt="Villa La Mainson"
              width={320}
              height={320}
              loading="eager"
              className="object-cover rounded h-full w-full"
            />
          </div>

          <div className="lg:col-span-2 flex flex-col justify-center gap-3">
            <h3 className="text-lg font-medium text-second">
              La Maison d'Ulysse Bali
            </h3>
            <div className="line-clamp-3 ">
              <p className="text-main">
                Looking to escape the ordinary and experience pure bliss? La Maison d’Ulysse Bali is just what you need! This luxurious retreat is the perfect place to unwind and enjoy a getaway like never before. Set in the lovely area of Umalas, Bali, you’ll be surrounded by breathtaking green rice fields – it’s truly like something out of a fairytale!
              </p>
            </div>
            <ul className="flex items-center gap-3 text-main">
              <li className="flex items-center">
                <BsFillPersonFill className="mr-2" />
                <span className="align-middle text-sm">8</span>
              </li>
              <li className="flex items-center">
                <IoBed className="mr-2" />
                <span className="align-middle text-sm">4</span>
              </li>
              <li className="flex items-center">
                <FaShower className="mr-2" />
                <span className="align-middle text-sm">4</span>
              </li>
            </ul>
          </div>
        </div>
      </CardContent>
    </Card>
  );
};

export default ResultForm;
