"use client";

import Image from "next/image";
import Link from "next/link";
import SheetMB from "../sheet-mb";
import {nav} from "@/app/data/navLink";

export default function HeaderAvailability() {
  return (
    <header className="w-full sticky top-0 z-10 md:static bg-white">
      <nav className="px-5 lg:px-0 flex justify-between items-center py-5 max-w-screen-lg mx-auto">
        <div className="flex-shrink mx-auto">
          <Link href="/">
            <Image
              src="/checkout/logo.svg"
              alt="Villa La Mainson"
              width={563}
              height={212}
              className="object-cover w-20 lg:w-40"
            />
          </Link>
        </div>
        {/* <div className="hidden lg:block">
          <ul className="flex justify-center items-center gap-6 h-16">
            {nav.map((link: any, index: number) => (
              <li
                key={index}
                className="text-xs md:text-base font-semibold tracking-[0.1px] text-main"
              >
                <Link href={link.href}>{link.title}</Link>
              </li>
            ))}
          </ul>
        </div>
        <SheetMB className="text-main" nav={nav} /> */}
      </nav>
      <hr className="border-main max-w-[1140px] mx-5 md:mx-auto" />
    </header>
  );
}
