"use client";

import {BsFacebook, BsInstagram, BsWhatsapp} from "react-icons/bs";
import Image from "next/image";

export default function FooterAvailability() {
  const currentYear = new Date().getFullYear();

  return (
    <>
      <footer className="">
        <div className="lg:max-w-6xl mx-auto py-5 space-y-10 lg:space-y-2">
          <hr className="w-[90%] lg:w-full border-main mx-auto" />
          <div className="w-full py-0 lg:py-5 px-5 lg:px-0 lg:mx-auto grid grid-cols-1 lg:grid-cols-6 gap-5 items-center">
            <Image
              src="/checkout/logo.svg"
              alt="Villa La Mainson"
              width={563}
              height={212}
              className="object-cover w-40 md:w-auto"
            />
            <div className="lg:col-span-2">
              <span className="text-main">
                Jalan Tegal Cupek, gang Wayang 46, no 3
              </span>
            </div>
            <div className="lg:col-span-2 flex flex-col text-main">
              <a href="https://wa.me/+6287765107836" target="_blank">
                Reservation: +62 877 6510 7836
              </a>
              <a href="mailto:hello@thetropicaldoor.com" target="_blank">
                Email: hello@thetropicaldoor.com
              </a>
            </div>
            <div className="lg:col-end-7 lg:text-right">
              <a
                href="https://maps.app.goo.gl/5BA2d3LzTTWCX7k56"
                target="_blank"
                className="underline underline-offset-4 font-bold text-main"
              >
                Get directions
              </a>
            </div>
          </div>

          <div className="w-full py-0 lg:py-5 px-5 lg:px-0 lg:mx-auto grid grid-cols-1 lg:grid-cols-6 gap-5 items-center">
            <div className="text-main">Follow us on</div>
            <div className="lg:col-span-2 flex flex-row gap-4">
              <a
                href="https://www.instagram.com/lamaisondulyssebali/"
                target="_blank"
              >
                <div className="bg-main rounded-lg p-[10px] flex items-center">
                  <BsInstagram size={20} className="text-white" />
                </div>
              </a>
              <a
                href="https://wa.me/+6287861854989?text=Hi%2C+I+saw+4BR+-+La+Maison+D'Ulysse+from+its+website%2C+and+I+would+like+to+enquire+about+this+villa."
                target="_blank"
              >
                <div className="bg-main rounded-lg p-[10px] flex items-center">
                  <BsWhatsapp size={20} className="text-white" />
                </div>
              </a>
            </div>
            <div className="lg:col-span-3 lg:text-right">
              <span className="text-main">
                © Copyright {currentYear} Villa La Mainson All Rights Reserved.
                <br className="hidden lg:block" /> Managed by
                <a href="https://thetropicaldoor.com" target="_blank">
                  The Tropical Door
                </a>
              </span>
            </div>
          </div>
        </div>
      </footer>
      <div className="fixed bottom-28 w-fit right-5 lg:right-10 z-[60]">
        <a
          href="https://wa.me/+6287861854989?text=Hi%2C+I+saw+4BR+-+La+Maison+D'Ulysse+from+its+website%2C+and+I+would+like+to+enquire+about+this+villa."
          target="_blank"
          className="bg-main p-4 border border-white rounded-full flex items-center"
        >
          <BsWhatsapp size={30} className="text-white" />
        </a>
      </div>
    </>
  );
}
