import Image from "next/image";
import Link from "next/link";

import type {Metadata} from "next";

export const metadata: Metadata = {
  title: "404NF Page || Villa La Mainson",
};


export default async function NotFound() {

  return (
    <main className="min-h-screen w-screen">
      <div className="grid grid-cols-1 lg:grid-cols-2 lg:h-auto h-screen">
        <div className="bg-white h-full lg:h-screen w-full flex justify-center items-center">
          <Image
            src="/checkout/logo.svg"
            alt="Logo"
            width={384}
            height={384}
            className="w-48 lg:w-[40rem]"
          />
        </div>
        <div className="bg-main flex flex-col justify-center items-center h-full lg:h-screen w-full gap-4 px-5 lg:px-0 text-center">
          <h1 className="text-white text-4xl">Something went wrong!</h1>
          <p className=" text-white text-lg">
            It looks like the page you looking for is no-show or already
            checked-out.
          </p>
          <Link href="/">
            <div className="bg-second text-white text-sm p-5 rounded w-fit font-bold">
              Take Me Home
            </div>
          </Link>
        </div>
      </div>
    </main>
  );
}
