"use server";

export async function postAvailability(form: any) {
  const id = process.env.roomID;

  const formData = {
    roomId: id,
    start: form.start,
    end: form.end,
    adult: form.adult,
    child: form.child,
  };

  try {
    const response = await fetch(
      "https://sys-direct.tongosngejang.com/api/availability",
      {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
          Authorization: `Bearer ${process.env.TONGOS_API_KEY}`,
        },
        body: JSON.stringify(formData),
        cache: "no-store",
      }
    );

    if (!response) {
      throw new Error("Checkout request failed");
    }

    const res = await response.json();

    if (res.success) {
      return res;
    } else {
      return {
        success: false,
        message: res.message,
      };
    }
  } catch (error) {
    console.log("Error getting ical", error);
    return {
      success: false,
      message: "Something went wrong, status process booking",
    };
  }
}

export async function postPayment(form: any) {
  const id = process.env.roomID;

  if (!id) {
    console.error("Room ID is not defined");
    return {success: false, message: "Missing room ID"};
  }

  const mode = process.env.NODE_ENV === "development"; // or however you check it

  const formData = {
    roomId: Number(id),
    start: form.start,
    end: form.end,
    adult: form.adult,
    child: form.child,
    usd: form.usd,
    idr: form.idr,
    firstname: form.firstname,
    lastname: form.lastname,
    phone: form.phone,
    email: form.email,
    address: form.address,
    message: form.message || "No Message",
    ...(mode ? {test: true} : {}),
  };

  try {
    const response = await fetch(
      "https://sys-direct.tongosngejang.com/api/payment",
      {
        method: "POST",
        headers: {
          "Content-Type": "application/json",
          Authorization: `Bearer ${process.env.TONGOS_API_KEY}`,
        },
        body: JSON.stringify(formData),
        cache: "no-store",
      }
    );

    const res = await response.json();

    return res;
  } catch (error: any) {
    console.log("Error processing api payment", error);
    return {
      success: false,
      message: error.message,
    };
  }
}
