"use server";

export async function getIcal() {
  const id = process.env.roomID;

  if (!id) {
    console.log("roomID is not set in environment variables");
    return [];
  }

  try {
    const res = await fetch(
      `https://sys-direct.tongosngejang.com/api/villa/calendar?formatted=true&roomId=${id}`,
      {
        method: "GET",
        headers: {
          "Content-Type": "application/json",
          Authorization: `Bearer ${process.env.TONGOS_API_KEY}`,
        },
      }
    );
    if (!res) {
      throw new Error("Network response was not ok");
    }
    const resData = await res.json();
    return resData;
  } catch (error) {
    console.log("Error getting ical", error);
    return [];
  }
}