"use server";

import FooterAvailability from "@/components/(main)/Footer";
import HeaderAvailability from "@/components/(main)/Header";
import ClientOnly from "@/components/client-only";

interface Props {
  children: React.ReactNode;
}

export default async function LayoutAvailability({children}: Props) {

  return (
    <ClientOnly>
      <main className="min-h-screen relative flex flex-col">
        <HeaderAvailability />
        <section className="w-full flex-grow px-5 lg:px-0 lg:max-w-6xl mx-auto py-5">
          {children}
        </section>
        <FooterAvailability />
      </main>
    </ClientOnly>
  );
}
